﻿/*==============================================================================================
   HTML Parsing Blocks. The following vars contain HTML code to be inserted in the Register
   Today HTML pages based on the business logic, e.g., whether the registration is for a company
   or individual, whether an old serial number is needed, whether State/Region/Province is 
   required, etc.

   (C) Copyright 2004 by Autodesk, Inc.  All rights reserved.
  ==============================================================================================*/

/////////////////////////////////////////////
// LOCALIZATION RESOURCES HERE:
/////////////////////////////////////////////

/////////////////////////////////////////////
// Product Language: 
//
// NOTE TO LOCALIZATION: The list below was inserted on 29 Jan 2001 and it was up to date at that point.
// You may use the codes detailed below if you are sure that these have not changed (they generally don't change), otherwise, 
// please check these before inserting the language code.
/////////////////////////////////////////////
//
//English - US and International:  (en-us)
//German:  (de)
//French:   (fr)
//Italian:   (it)
//Spanish:   (es)
//Czech:   (cs)             
//Hungarian:   (hu)
//Polish:   (pl)
//Russian:   (ru)
//Japanese:   (ja)
//Korean:   (ko)
//Traditional Chinese (Taiwan) :   (zh-tw)
//Simplified Chinese (PRC) :   (zh-cn)
//Brazilian Portuguese (pt-br)
//
/////////////////////////////////////////////

//////////////////////////////////////////////
///// Add as ECO17 Direct Addition to the Privacy Policy 
/////
var xmsgGatherInfoDuringInstall= "Please note that all data gathered during product activation is used in accordance with the Autodesk ";
var xmsgOfflinePrivacyWarning= "If you are not connected to the Internet, set your Internet Explorer (R) browser encoding to Auto-Select in order to view the privacy policy. If you can access the Internet, the privacy policy is also available online at autodesk.com."
////////////////////////////////////////////////////

var xmsgProductLanguage=	"en-us";

/////////////////////////////////////////////
// Disable field color
/////////////////////////////////////////////
var xmsgDisableColor=		"#7f7f7f";

var xmsgNavigationBGColor=	"#f4f4f4";
var xmsgNavigationDisableColor=	"#808080";

/////////////////////////////////////////////
// HTML FILE TITLE STRINGS
/////////////////////////////////////////////
var xmsgRTAuthConfirmed=				"Activation Complete";
var xmsgRTActLicFound=                  "Activated License Found";
var xmsgRTActLicFoundError=            "Registration-Activation Error"; 
var xmsgRTAuthEntryError=				"Activation Entry Error";
var xmsgRTAuthError=					"Activation Error";
var xmsgRTAuthNow=						"Auth Now";
var xmsgRTBeginReg=						"Activation Options";
var xmsgRTBuyInformation=				"Purchase Information";
var xmsgRTConfirm=						"User Confirm";
var xmsgRTConnect=						"Internet Connection Required";
var xmsgRTConnectFail=					"Connection error";
var xmsgRTContactAutodesk=				"Contact Autodesk";
var xmsgRTOfflineActivationRequest=     "Offline Activation Request"
var xmsgRTCountryPage=					"Country";
var xmsgRTEmail=						"Email";
var xmsgRTFaxUS=						"User Fax US";
var xmsgRTMailUS=						"User Mail US";
var xmsgRTPurchaseOffline=				"Purchase Offline";
var xmsgRTRegConfirmed=					"Registration Confirmed";
var xmsgRTExportConfirm=                "License Export Confirmation";
var xmsgRTImportConfirm=                "License Import Confirmation"; 
var xmsgRTRegVol=						"Product Registration";
var xmsgRTSUNDataConfirm=				"SUN Data Confirm";
var xmsgRTSUNServer=					"SUN Server";
var xmsgRTSUNSubmit=					"User Confirm/Submit SUN";
var xmsgRTUserInfo=						"User Information";
var xmsgRTLicFileSaveError=				"Flexlm License File Save Error";
var xmsgRTProductInfo=                   "Product Information Required";
var xmsgRTProductInfo2=                   "Activation Options";
var xmsgNSARTBegin=						"Obtain A Network License";
var xmsgNSARTLocateLicense=				"Locate License File";
var xmsgNSARTEditServerAndSeat=			"Enter of Modify Server Information";
var xmsgNSARTConfirmServerAndSeat=		"Confirm Server Information";
var xmsgNSARTEnterSN=					"Enter Serial Number";
var xmsgProcessingError=				"Processing Error";
var xmsgTimeout=        				"This Session Has Timed Out";
var xmsgLicenseActivation=        		"Activating";
var xmsgLicenseTransfer=        		"License Transfer";

/////////////////////////////////////////////
// Software Information RESOURCES HERE:
/////////////////////////////////////////////
var xmsgActivationFor=	"Activation for:";
var xmsgPurchase=       "Purchase:";
var xmsgRegistrationFor=       "Registration for:";
var xmsgProduct=	"Product: ";
var xmsgsernum=		"Serial Number: ";
var xmsgsernumWGID=	"Serial Number: ";//modify by joyce.min on 2007-8-16
var xmsgprokeyWGID=  "Product Key: "; // add by  joyce.min on 2007-8-16
var xmsgOsernum=	"Previous serial number: ";
//var xmsgOprokey=      "Previous product key: "; // add by joyce.min on 2007-8-17
var xmsgOldSerialNum=	"Previous serial number:*";
var xmsgNewSernum1=	"Enter your serial number or Group ID:"; //???
//var xmsgNewProkey1=
var xmsgRequestCode=	"Request code: ";
var xmsgRegAuthCode=	"Activation code: ";
var xmsgApplicationKey=	"Application key: ";
var xmsgRTHostID=				"Host ID:";
var xmsgRTFlexlmLicenseFile=	"License file:";

/////////////////////////////////////////////
// Primary Rolodex RESOURCES HERE:
/////////////////////////////////////////////
var xmsgSalutation=	"Salutation:";
var xmsgNone=		"(none)";
var xmsgNotEntered=	"(not entered)";
var xmsgFirstname=	"First name:";
//var xmsgFirstname= langCode+label.fname;
var xmsgFirstnameKanji=	"First name (Kanji):";
var xmsgFirstnameFurigana=	"First name (Zenkaku Kana):";
var xmsgLastname=	"Last name:";
var xmsgLastnameKanji=	"Last name (Kanji):";
var xmsgLastnameFurigana=	"Last name (Zenkaku Kana):";
var xmsgCompanyName=	"Company name:*";
var xmsgCompanyName2=	"Company name:";
var xmsgCompanyNameJP=	"Company name (Kanji):";
var xmsgPhone=		"Telephone:";
var xmsgArea=		"Area:";
var xmsgNumber=		"Number:";
var xmsgExt=		"Extension:";
var xmsgFax=		"Fax:";
var xmsgFaxTo=		"Fax to ";
var xmsgEmail=		"Email:";
var xmsgEmailTo=	"Email to ";
var xmsgAddress=	"Street address:";
var xmsgAddress2=	"Street address 2:";
var xmsgAddress3=	"Street address 3:";
var xmsgJPAddress=	"Town:";
var xmsgJPAddress2=	"Street address:";
var xmsgJPAddress3=	"Building name (and Suite number):";
var xmsgCity=		"City:";
var xmsgSRP=		"State/Region/Province:";
var xmsgStText=		"State:";
var xmsgPrText=		"Province:";
var xmsgRegText=	"Region:";
var xmsgPrefectureText=	"Prefecture:";
var xmsgCountyText=	"County:";
var xmsgCantonText=	"Canton:";
var xmsgZipCode=	"Zip code:";
var xmsgPostCode=	"Post code:";
var xmsgCountry=	"Country or region:";
var xmsgDealer=		"Autodesk Authorized Reseller name:";
var xmsgMailTo=		"Mail to ";
var xmsgAnEmail=	"an email address";
var xmsgAFax=		"a fax number";
var xmsgAMailAddress=	"a mailing address";
var xmsgPostalMail=		"Postal mail";

///////////////////////////////////////////////
// Button RESOURCES HERE:
///////////////////////////////////////////////
var xmsgBack=			"Back";
var xmsgCancel=			"Close";
var xmsgNext=			"Next";
var xmsgPrint=			"Print";
var xmsgPrintForm=		"Open Activation Request Form";
var xmsgNo=				"No";
var xmsgYes=			"Yes";
var xmsgBrowse=			"Browse";
var xmsgDone=			"Done";
var xmsgOK=				"OK";
var xmsgClose=			"Close";
var xmsgSubmit=			"Submit";
var xmsgFinish=			"Finish";
var xmsgReset=			"Clear All";

///////////////////////////////////////////////
// Registration User Prompt RESOURCES HERE:
///////////////////////////////////////////////
var xmsgPleaseSelect=		"Please select ";
var xmsgPleaseSelect2=		"To activate your %1 license immediately, please select \"Connect now and activate!\” again. If you still experience problems during activation, and if you requested and received an activation code from Autodesk, select \"I have an activation code from Autodesk\".";
var xmsgSelectCountry=		"Country/Region in which the product will be used:";
var xmsgSelectCountry2=		"Country/Region:";
var xmsgInformation=		"Information";
var xmsgCompanyInfo=		"Company Information:";
var xmsgContactInfo=		"Contact Information:";
var xmsgResponseMethodInfo=	"Response Method:"; //modify as the Spec. recommond by joyce.min on 2007-8-17
var xmsgFormSubmitMethodInfo=	"Form Submit Method:";
var xmsgConfirmInfo=		"Confirm Information";
var xmsgConfirmInfoTxt=		"Review the following information.  Click one of the form submit method links to continue, using the information shown.  Click Back to make changes.";
var xmsgConfirmCustIDInfoTxt=		"Confirm the following information. Click Next to continue, or click Back to make changes.";
var xmsgCountryHdr=			"Product Registration";
var xmsgCountryRegTo=		"This product will be registered to:";
var xmsgCountryComp=		"Company";
var xmsgCountryIndiv=		"Individual";
var xmsgCountryUpgrade=		"This is an upgrade";
var xmsgCountryUpgDetail=	"(If you are a subscription customer, click No)";
var xmsgConnectHdr1=		"Connecting";
var xmsgConnectHdr2 = "Activating your product license…";
var xmsgConnectHdr = "Internet Connection Required";
var xmsgConnectMsg=		"Connection";
var xmsgConnectTxt=		"No Internet connection was detected. To submit an online request, connect to the Internet now. When an Internet connection is established, click Next.";
var xmsgConnectTxtOLT=    "No Internet connection was detected. To transfer a license, connect to the Internet now.";
var xmsgConnectTxt2=	"When an Internet connection is established, click Next.";
var xmsgConnectTxt2a=	"Once you are connected to the Internet, click Next.";
var xmsgConnectTxt3=	"If you cannot establish an Internet connection, you may also choose to send your request to Autodesk using an alternate method.";
var xmsgConnectTxt4=	"It looks like you are not connected to the Internet.  In order to purchase a license for this product, an Internet connection is required.";
var xmsgConnectTxt4a=	"It looks like you are not connected to the Internet.  In order to activate or purchase a license for %1, an Internet connection is required.";
var xmsgConnectWarming=	"Submitting this information may take a few minutes. Please wait.";
var xmsgTryAgain=		"Try again";
var xmsgReEnterOld=		"Re-enter previous serial number";
var xmsgNewSernum3=		"Please enter your New Serial Number and click Next.";
var xmsgNewSernum4=		"Your trial software is installed with a Serial Number (000-00000000) that " +
						"cannot be registered. If you purchased a copy of this software, you were " +
						"issued a New Serial Number. You must use this Serial Number to activate and " +
						"enable your product for use.";
var xmsgNewSernum5=		"Enter your serial number:"; //modify by joyce.min on 2007-8-16
var xmsgProductKey=      "Enter your product key:"; //modify by joyce.min on 2007-8-16
var xmsgNewSernum6=		"Confirm new serial number:";
var xmsgNewSernum8=		"Re-enter New Serial Number";
var xmsgUseOtherMethod=		"Use another registration method";
var xmsgContactAutodesk=	"Contact Autodesk";
var xmsgContactAutodeskLink="To contact Autodesk, click the following link:";
var xmsgContactOptions=		"contact options are shown below.";

var xmsgPuchaseInfo1=		"Purchase Information";
var xmsgPuchaseInfo2=		"You have chosen to purchase online."; //modify as the LF1_Spec_SCV commend on p99 by joyce.min
var xmsgPuchaseInfo3=		"Click Next to continue, or Close if you do not wish to proceed."; //modify as the LF1_Spec_SCV commend on p99 by joyce.min

var xmsgRegTitle=		"Registration - Activation";
var xmsgRegTitleBuy=		"Purchase Autodesk products on-line";
var xmsgRegTitleNSA=		"Network License Activation";
var xmsgRegInfo=		"Customer Information";
var xmsgRegInfo2=		"Registration Method";
var xmsgRegInfo3=		"Please select a registration method and click Next.";
var xmsgRegmethod1=		"Connect directly via the Internet";
var xmsgRegmethod3=		"I would like to receive my activation code by:";
var xmsgRegmethod5=		"Mail";
var xmsgRegmethod6=		"Click Print below and mail this form to:";
var xmsgRegmethod7=		"Fax";
var xmsgRegmethod8=		"To print a form that you can fax to Autodesk at %1, first choose the method "+
						"by which you want to receive your activation code. Then, click Print. "+
						"You can then fax the form.";
var xmsgRegmethod9=		"Email";
var xmsgRegmethod10NSA=		"Your registration and license server information (shown below) " +
							"has been automatically saved to a file.";
var xmsgRegmethod10=		"Your registration information has been saved to the following file, "+
							"which will be used to complete the email process (do not modify this file):";
var xmsgRegmethod11NSA=		"Email the registration and license server information file %1 to %2.";
var xmsgRegmethod11=		"Email the registration information file %1 to %2.";
var xmsgRegmethod12=		"Make sure you do not modify the file.<p>" +
							"It is recommended that you print a copy of this page and put it in " +
							"a safe place. You will need this information to complete the email "+
							"process manually.<p>" +
							"You can print a copy of this information for your records. Click Done " +
							"to close this application.";
var xmsgRegmethod13=		"To automatically attach and send %1 to Autodesk, click the link below.";
var xmsgRegmethod14=		"Send my request by Email";
var xmsgRegmethod15=		"Note: The email address is automated. Do not send email communications to this address.";
var xmsgRegmethod16=		"To register by fax or by mail, click one of the following links:";
var xmsgRegmethod17=		"Error Sending Email";
var xmsgRegmethod18NSA=		"An error occurred while the system attempted to send the registration and license server information automatically.";
var xmsgRegmethod18=		"An error occurred while the system attempted to send the registration information automatically.";
var xmsgRegmethod19=		"To Email the file manually:";
var xmsgRegmethod20NSA=		"Email the registration and license server information file %1 to %2.";
var xmsgRegmethod20=		"Email the registration information file %1 to %2.";
var xmsgRegmethod21=		"Make sure you do not modify the file.<p>" +
							"It is recommended that you print a copy of this page and put it in a safe place. " +
							"You will need this information to complete the email process manually.<p>" +
							"You can print a copy of this information for your records. Click Done to "+
							"close this application.";
var xmsgRegAuthInfo=		"Product License Activation Options";
var xmsgRegAuthInfo1=		"Registration Confirmation";
var xmsgRegExpConfirm=      "License Export Confirmation";
var xmsgRegImpConfirm=      "License Import Confirmation";
var xmsgRegAuthInfo2 =      "Connect now and activate! (Recommended)";
var xmsgRegAuthInfo2Hover = "Connect with Autodesk and immediately activate your product license (requires an Internet connection)";
var xmsgRegAuthInfo3=		"Enter Activation Code"; 
var xmsgRegAuthInfo4=		"Select an option below:";
var xmsgRegAuthInfo4A =     "I have an activation code from Autodesk";
var xmsgRegAuthInfo4AHoverA = "Type the activation code that you requested and received from Autodesk.<br>To simplify this step, paste your entire activation code in the first box. The remaining boxes are automatically filled.";
var xmsgRegAuthInfo4AHoverB = "Enter the file path and name or browse to the Activation File provided by Autodesk in response to your email request.";
var xmsgRegAuthInfo4B=		"Enter activation code:"; 
var xmsgRegAuthInfo5=		"Please select country or region, enter activation code and click Next.";
var xmsgRegAuthInfo6=		"Product License Activation";	
var xmsgRegAuthInfo6a=		"Thank You For Activating";	
var xmsgRegAuthInfo7=		"%1 has been successfully activated.";
var xmsgRegAuthInfo8=		"Confirmation";		
var xmsgRegAuthInfo9=		"Thank you for registering your Autodesk product. This will help us to serve you better in future.";
var xmsgRegAuthInfo10=		"A copy of your activation information has been saved to:";		
var xmsgRegAuthInfo10B=		"A copy of your activation information has been saved to:";
var xmsgRegAuthInfo14=		"Congratulations on the purchase of %1. Under the terms of  your activated license, one or more products are allowed to run on your computer.";
var xmsgRegAuthInfo14a=		"Under the terms of  your activated license, one or more products are allowed to run on your computer.";
var xmsgRegAuthInfo15=		"Uninstalling %1 does not remove the license.";
var xmsgRegAuthInfo16=		"License Active";
var xmsgRegAuthInfo17=		"Congratulations!";
var xmsgRegActLicInfo=      "Activated License Found";
var xmsgRegActLicInfoError=      "Registration-Activation Error";
var xmsgRegActiveInfo=        "Type or browse to the Activation File:";
var xmsgRegActLicInfo1=       "A previously registered and activated license for your product was found on this computer and is now in use."
var xmsgRegActLicInfo1Error= "A previously registered and activated license for your product was found on this computer.\n However, an unexpected error (%1) has occured. Please close the application and try again. If this problem continues, contact your system administrator or authorized Autodesk product dealer";

/////////////////////////////////////////////
// OLT Confirmation
/////////////////////////////////////////////
var xmsgExportSuccess=        "Export Success"; //2008-01-16
var xmsgExportFail=           "Export Request Failed" ; //2008-01-16
var xmsgRegErrRef=            "Error reference:"; //2008-01-17
var xmsgImportSuccess=        "Import Success"; //2008-01-16
var xmsgImportFail=           "Import Request Failed"; //2008-01-16
var xmsgExpSucessInfo=        "Your license has been successfully exported and is now on the Autodesk server."; //2008-01-16
var xmsgExpSuccessInfoHowtoImport=    "How to Import Your License";
var xmsgExpSucessInfo1=        "Before starting the product on the destination computer, use the License Transfer utility to import this license to that computer and be ready to enter your Autodesk User ID and password.";  //2008-01-16
var xmsgImpSucessInfo=         "The license has been successfully imported; you may now use this product. "; //2008-01-16
var xmsgImpRemindInfo=         "Remind me to export."; //2008-01-16
var xmsgImpRemindInfo1=        "Checking this box will result in a dialog each time you exit to remind you to export the license.";//copy mockup 2008-01-16
var xmsgImpRemindInfo2=        "This is useful if you are importing the license to this computer temporarily and will need to transfer it back.";//copy mockup 2008-01-16
var xmsgImpRemindInfo3=        "A \"do now show me this again\" option is available in the reminder.";//copy mockup 2008-01-16
var xmsgOltTryAgain=           "Click the \"Try Again\" link to resubmit the request. ";
var xmsgImpFailMsg=            "If the problem persists, you should activate the license, rather than import it.";

var xmsgReqfilelocMsg=       "The request file is located at:";	//add by joyce.min on 2007-9-10 as Licensing Spec. recommend 	
var xmsgRegAuthInfo11=		"Thank you for registering - your product is now activated and your license file has been saved. "+
							"Click Print to keep a record of this information.";
var xmsgRegAuthInfo12=		"Paste the activation code.";
var xmsgRegAuthInfo13=		"Type the activation code.";
var xmsgRegErrorActiveCode=    "<FONT color=red>Enter an activation code to proceed.</FONT>";
var xmsgRegErrorActiveCode1=    "<FONT color=red>The activation code is invalid.  Check the code for errors.</FONT>";
var xmsgRegErrorActiveFile=    "<FONT color=red>Enter an activation file path and name to proceed.</FONT>";
var xmsgRegErrorSernum=      "<FONT color=red>Enter a serial number to proceed.</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorSernum1=      "<FONT color=red>The serial number is too short.</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorProkey=      "<FONT color=red>Enter a product key to proceed.</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorProkey1=     "<FONT color=red>The product key is too short.</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorHdr=		"Registration-Activation Error";
var xmsgRegErrorSystem=		"A temporary system problem is causing errors in your registration. "+
							"Click one of the following links."
var xmsgRegErrorPrevReg=	"This Serial Number that you entered is already registered.";
var xmsgRegErrorMaxAuth=	"You have exceeded the number of activations allowed for this product.";
var xmsgRegErrorMaxAuth2=	"You have exceeded the number of licenses allowed for this product.";
var xmsgRegErrorInvalidOld=	"The serial number that you entered for your previous product is not "+
							"valid. Verify that the previous serial number displayed above is correct. " +
							"Click one of the following links.";
var xmsgRegErrorData=		"There is a problem with the registration data that you provided. Select " +
							"Try Again to review and correct the information you entered, use a different method " +
							"to register, or contact Autodesk to continue.";
var xmsgRegErrorNetwork=	"The product you are attempting to register is a network-authorized product " +
                            "and must be installed as such. You must uninstall your software and select " +
                            "\"Network\" for the installation type.<p>Please refer to the Network installation " +
                            "section of the installation guide for the proper installation and activation " +
                            "procedures for the Network Version.";
var xmsgRegNoResponse=		"A temporary problem is causing errors in your online registration. " +
							"Click one of the following links.";
var xmsgRegErrorAuthEntry=	"There is a problem with the activation code that you entered. " +
							"Click one of the following links.";
var xmsgRegErrorAuthPermission = "To activate this Autodesk product, you must either have administrator permissions or be " +
                            "granted elevated permissions by your system administrator. See your system administrator "+
                            "for more information about administrator and elevated permissions.";							
var xmsgRegErrorAuth=		"There is a problem with the activation code. Click one of the following links.";
var xmsgRegErrorFlex=		"There is a problem with the license. Click one of the following links.";
var xmsgRegConnError=		"Connection Error";
var xmsgRegConnErrorTxt=	"There is a problem with the Internet connection. Click one of the following links.";
var xmsgRegPurchError3=		"Use another purchase method";
//modified as LFSpec_SCV commend by joyce.min
var xmsgRegPurchError5=		 "Thank you for choosing Autodesk software.<p>A connection to complete this " +
							"process is currently unavailable, possibly due to your system settings.<p>A click on " +
							"either of the links below will open your browser and may enable you to connect successfully.<p>";

var xmsgAuthResellerMsg1=	"Purchase from your local reseller. Contact your local reseller to complete your purchase.";

var xmsgLicSaveErrInfo=		"An error occurred while saving your license file. Click one of the following links.";

var xmsgOnlineStoreMsg1=	"Purchase at the Autodesk Online store. If you are unable to find the product you are looking " +
							"for at the store, please contact an Authorized Reseller.";
var xmsgOnlineStoreMsg2=    "Online Store";
var xmsgAuthResellerMsg2=	"Authorized Reseller";
var xmsgLocateLicenseMsg1=	"Locate License File";
var xmsgLocateLicenseMsg2=	"Enter a path to the license file (or use Browse to locate one), " +
							"and then click Next to continue.";
var xmsgLocateLicenseMsg3=	"Existing license file:";
var xmsgUserContactMsg=		"You must enter at least one of the following:";
var xmsgFailureMsg=		    "Your online activation request could not be processed.";

/////////////////////////////////////////////
// Default Ereg returned error messages
/////////////////////////////////////////////
var xmsgDefaultEregReturnedErrMsg=  "Your online activation request has returned an error (%1) " +
                            "which is not allowing your request to be processed using " +
                            "our automated systems.";
var xmsgRegErrorOnline=		"Click the \"Use another method\" link below to complete the "+
                            "necessary forms and submit your request to the local "+
                            "Autodesk Business Center for your area.  A Customer Service Representative "+
                            "will respond within the next 2 business days.";
var xmsgAnotherFormSubmitMethod=    "Use another method";
var xmsgOfflineRegistrationMethod=    "Request an activation code using an offline method";
var xmsgOfflineRegistrationMethodHover= "Prepare an activation code request for your product license using a computer with an Internet connection";

/////////////////////////////////////////////
// Timeout message
/////////////////////////////////////////////
var xmsgTimeoutMsg1=    "Your online activation request has timed out."
var xmsgTimeoutMsg2=    "Click the \"Try again\" link to resubmit the online request. "+
                        "If the problem persists, you may click the \"Use another method\" "+
                        "link to complete the necessary forms and submit your request using "+
                        "email, fax, or other options.";
var xmsgTimeoutMsg2a=    "Click the \"Try again\" link to resubmit the online request. "+
                        "If the problem persists, you may have to close the application and attempt activation at a later time.";

/////////////////////////////////////////////
// Single User Network RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegSunData1=		"Registration Data Saved";
var xmsgRegSunData2=		"The registration data required for client deployment has been saved in ";
var xmsgRegSunData3=		"The Previous Serial Number supplied for this upgrade registration is not valid. Please contact your administrator.";
var xmsgRegSunData4=		"This software must be re-installed with a valid Previous Serial Number.";
var xmsgRegSunData5=		"Multi-Seat Stand-Alone Deployment";
var xmsgRegSunData6=		"In order to complete the multi-seat stand-alone deployment, some registration information is required. The following pages will:";
var xmsgRegSunData7=		"Collect required information.";
var xmsgRegSunData8=		"Allow for previous serial number entry if required for an upgrade.";
var xmsgRegSunData9=		"Store this information on the server for deployment to all client installations.";
var xmsgRegSunData10=		"This software will be registered using the following information. Click Next to proceed.";

/////////////////////////////////////////////
// Voluntary RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegVol1=	"Product Registration";
var xmsgRegVol2=	"Select an option and then click Next:";
var xmsgRegVol3=	"Register now - select this option to begin online registration";
var xmsgRegVol4=	"Register later - select this option to run your software now";
var xmsgRegVol5=	"Don't show me this again.";
var xmsgRegVol6=	"(If you wish to register later, you can select the registration option in the Help|About dialog)";

/////////////////////////////////////////////
// Japan RESOURCES HERE:
/////////////////////////////////////////////
var xmsgCustIDMainTitle=	"Customer Identification";
var xmsgKatakana=		    "Company name (Zenkaku Kana):";
var xmsgDepartment=		    "Department:";
var xmsgDepartment2=		"Department name:";

/////////////////////////////////////////////
// Autodesk Contact RESOURCES HERE:
/////////////////////////////////////////////
var xmsgFormWebHdr=	"On the Internet:";
var xmsgFormWebDataMsg1 = "You can also request an activation code by visiting:&nbsp;&nbsp;";
var xmsgFormEmailHdr=	"Email:";
var xmsgFormEmailData=	"";
var xmsgFormEmailDataBlock= "";
var xmsgFormEmailXMLData=	"";
var xmsgFormEmailXMLDataBlock= "";
var xmsgFormFaxHdr=		"Fax:";
var xmsgFormFaxHdrLocal=	"Fax local office:";
var xmsgFormFaxHdrReg=	"Fax registration:";
var xmsgFormFaxData=	"";
var xmsgFormFaxDataRegister=	"";
var xmsgFormCallHdr=	"Telephone:";
var xmsgFormCallData=	"";
var xmsgFormMailHdr=	"Postal Mail:";
var xmsgFormMailHdrLocal=	"Mail local office:";
var xmsgFormMailHdrReg=	"Mail registration:";
var xmsgFormMailData=	"";
var xmsgFormMailDataRegister=   "";
var xmsgFormPurchHdr=	"Purchase software";
var xmsgFormInternetMsg=    "To use your web browser to request an activation code, click the link."
var xmsgFormEmailMsg=       "Email correspondence and activation requests to:"

/////////////////////////////////////////////
// Privacy Statement RESOURCES HERE:
/////////////////////////////////////////////

var JPprivacystatement = "The information you provide will be used by Autodesk to register and/or issue your " +
			"activation code. Registration confirms your consent for Autodesk to provide information " +
			"about you to our Authorized Business Partners for product license management and " +
			"entitlement verification purposes. Please contact Autodesk at " +
			"<a href=mailto:information@autodesk.jp target=\"_blank\">information@autodesk.jp</a> " +
			"if you prefer Autodesk not share your information with its Authorized Business Partners for " +
			"these limited purposes.    If you want to correct or update your registration data, please click "+
			"<a %1>HERE</a> " +
			"to contact Autodesk, or contact your local Autodesk office.";
			
var privacystatement = "The information you provide will be used by Autodesk to register and/or issue your activation code, " +
			"to keep you informed about our products and services, and to ensure that you benefit from being an " +
			"authorized Autodesk user. Autodesk does not sell or otherwise provide your information to anyone " +
			"outside of Autodesk or our Authorized Business Partners. If you want to correct or update previously " +
			"registered customer information, please click " +
			"<a %1>HERE</a> " +
			"to contact Autodesk, or contact your local Autodesk office.";
				
			
/////////////////////////////////////////////
// Privacy Policy
/////////////////////////////////////////////
var xmsgPrivacyPolicy="Privacy Policy";

/////////////////////////////////////////////
// Copyright
/////////////////////////////////////////////
var xmsgCopyright="Copyright 2015 Autodesk, Inc. All rights reserved.";

/////////////////////////////////////////////
// Rebranding Message
/////////////////////////////////////////////
var xmsgRebranding="In most cases, the new serial number will not be displayed until you close the program and "+ 
                   "restart the program with Administrator rights.";
var xmsgRebranding2="Refer to your operating system documentation for information on how to start programs with Administrator rights.";
/////////////////////////////////////////////
//  Note to Localization :
//
//	"Fields marked in <FONT color=red>red</FONT> and with an asterisk (<FONT 
//	color=red>*</FONT>) are required to process your registration. Complete the form 
//	and click Next."
//
/////////////////////////////////////////////
var xmsgRegInfoMsg1= "Fields marked <FONT color=red>*</FONT> are required.";
var xmsgRegInfoMsg2= "The information you enter on this page is stored with your license. "+
					 "It is used for product re-activation and upgrades. Make sure you enter "+
					 "valid information here to avoid delays in using your product.";

var xmsgLicLocationText1 = "Save license file for <b>%1</b> to:";

// Set Registration Info Header
var InsertRegInfo =     "<p><b>"+xmsgRegInfo+"</b></p>" +
			  "<p>" + xmsgRegInfoMsg1 + "</p>";


//=======================================================================
// Application Usage Information
//=======================================================================
var xmsgAppUsage=	"Questions:";

var xmsgAppUsageQ1=	"To help Autodesk better understand the needs of your industry, "+
					"please answer the following question.";
var xmsgAppUsageQ2=	"Which of the following best describes your primary field?";

var xmsgAppUsageOption51=	"Aerospace and Automotive Component Design ";
var xmsgAppUsageOption52=	"Architectual Design ";
var xmsgAppUsageOption53=	"Building and Facility Management ";
var xmsgAppUsageOption54=	"Building Construction: Commercial ";
var xmsgAppUsageOption55=	"Building Construction: Residential ";
var xmsgAppUsageOption56=	"Building Equipment Manufacturing ";
var xmsgAppUsageOption57=	"Civil Engineering / Land Planning ";
var xmsgAppUsageOption58=	"Computer / Medical / Office Equipment Design ";
var xmsgAppUsageOption67=	"Consumer Products Design ";
var xmsgAppUsageOption59=	"Corporate Building Ownership ";
var xmsgAppUsageOption92=	"Defense ";
var xmsgAppUsageOption93=	"Electrical Controls Design ";
var xmsgAppUsageOption94=	"Electrical Systems Engineering ";
var xmsgAppUsageOption72=	"Environmental Engineering ";
var xmsgAppUsageOption95=	"Fabricated Metal Products ";
var xmsgAppUsageOption96=	"Interior Design ";
var xmsgAppUsageOption97=	"Machinery Design ";
var xmsgAppUsageOption98=	"Manufacturing Procurement / Sales / Marketing ";
var xmsgAppUsageOption40=	"Mapping and Geospatial Design ";
var xmsgAppUsageOption41=	"Mechanical Systems Engineering (HVAC and Piping) ";
var xmsgAppUsageOption42=	"Plumbing and/or Fire Protection Systems Engineering ";
var xmsgAppUsageOption43=	"Process and Power Plant Design ";
var xmsgAppUsageOption44=	"Real Estate Development ";
var xmsgAppUsageOption45=	"Structural Engineering ";
var xmsgAppUsageOption87=	"Telecommunications ";
var xmsgAppUsageOption46=	"Tool and Die / Machine Shop ";
var xmsgAppUsageOption47=	"Transportation Design ";
var xmsgAppUsageOption48=	"Utilities:  Electric, Oil and Gas ";
var xmsgAppUsageOption49=	"Utilities:  Water and Sewer ";
var xmsgAppUsageOption99=	"Other ";

var xmsgWrongCountryCodeMsg=	"Error: No known country code input!";

/////////////////////////////////////////////
// Version RESOURCES HERE:
/////////////////////////////////////////////
var xmsgVersion = "Version:"

/////////////////////////////////////////////
// Access RTFax or RTMail through RTEmail
/////////////////////////////////////////////
var xmsgAccessFaxMsg=		"I will send my request by fax or phone"; //modify by joyce.min on 2007-10-18 as Licensing_Framework Spec_Frozen.doc recommend 
var xmsgAccessMailMsg=		"Register by mail.";
var xmsgAccessHereMsg=		"here.";

/////////////////////////////////////////////
// Receive code by
/////////////////////////////////////////////
var xmsgReceiveCodeMsg=     "I would like to get the code by:";
var xmsgReceiveCodeMsg1=     "I will receive my activation file by email"; //add by joyce.min on 2007-8-20
/////////////////////////////////////////////
// Messages for Ease of reauth or multi-seat client registration
/////////////////////////////////////////////
var xmsgNoDialogHdrMsg=		"Please wait while your license is <br>being verified";
/////////////////////////////////////////////
//Resource for RTProductInfo
/////////////////////////////////////////////
var xmsgRTProductInfoTitle=      "Product Information Required"; //add by joyce.min on 2007-8-14
var xmsgRTProductInfoTitle2=      "Enter Serial Number and Product Key"; // Project Coooper Design
var xmsgOnlineStoreDefaultURLForProductInfo = "http://www.autodesk.com/estore/usa/index.htm";
var xmsgRTProductInfoMsg1=        "To activate %1, please enter the Serial Number and Product Key you received at the time of purchase in the fields below. This information can be found on the product package, in your \"Autodesk Upgrade and Licensing Information\" email, or a similar confirmation email from the point of purchase e.g. online store.";
var xmsgRTProductInfoMsg2=        "If you do not have a Serial Number and Product Key and would like to purchase it now, <a href="+ xmsgOnlineStoreDefaultURLForProductInfo +" target=\"_blank\">click here</a>.";
/////////////////////////////////////////////
//Error for RTProductInfo
/////////////////////////////////////////////
//var xmsgsernumError=        "Enter a serial number to proceed."; //add by joyce.min on 2007-8-17
//var xmsgprokeyError=        "Enter a product key to proceed." ; //add by joyce.min on 2007-8-17
/////////////////////////////////////////////
// Resource for NSA_RTBegin.html
/////////////////////////////////////////////
var xmsgNSARTBeginTitle=	"Obtain A Network License";
var xmsgNSARTBeginMsg1=		"Request a network license activation file by:";
var xmsgNSARTBeginMsg2=		"Direct connect (over the Internet)";
var xmsgNSARTBeginMsg3=		"Email, fax, phone, or send the request by postal mail";
var xmsgNSARTBeginNoInternet=	"";

/////////////////////////////////////////////
// Edit server and seat information
/////////////////////////////////////////////
var xmsgEditServerHdrMsg1=	"Server Information";
var xmsgEditServerHdrMsg2=	"License server model*";
var xmsgEditServerMsg1=		"Enter your license server information.<br>"+
							"Click on the Lookup button to populate the Server Host ID field.<p>";
var xmsgEditServerMsg2=		"Begin with server host data from existing license file(s).";
var xmsgEditServerRemove=	"Remove";
var xmsgEditServerHostName=	"Server host name*";
var xmsgEditServerHostID=	"Host ID*";
var xmsgEditServerSeat=		"Seats*";
var xmsgEditServerSingle=	"Single Server";
var xmsgEditServerDistributed=	"Distributed Server";
var xmsgEditServerRedundant=	"Redundant Server";
var xmsgEditServerDots=		"...";
var xmsgEditServerLookup=	"Lookup";
var xmsgEditServerAddServer=	"Add";
var xmsgEditServerRemoveServer=	"Remove";
var xmsgEditServerTotal=	"Total:";
var xmsgEditServerExceedMaxServer=	"Note: You can license a maximum of 20 distributed servers at one time. If you need to license more than 20 servers, "+
									"contact Autodesk.";
var xmsgEditServerSeatError=	"Seats must contain numeric values only.";

var xmsgConfirmServerMsg=	"Review the following information. Click Next to continue or click Back to make changes.";
var xmsgConfirmServerMsg2=	"When you click Next, this information will be sent to Autodesk over the Internet.";
var xmsgConfirmServerHdr2=	"License server model:";
var xmsgConfirmServerHostName=	"Server host name";
var xmsgConfirmServerHostID=	"Host ID";
var xmsgConfirmServerSeat=		"Seats";
var xmsgConfirmServerTotal=		"Total seats:";

var xmsgLicErrorHdr=			"Licensing Error"; 
var xmsgLicErrorInvalidSN=		"The Serial Number that you entered is not valid. Verify that the serial number displayed "+
								"above is correct. Click one of the following links.";
var xmsgLicReEnterSN=			"Re-enter serial number and try again.";

var xmsgLic113Msg2=				"The total number of seats you have allocated to your distributed servers exceeds that number.";
var xmsgLic113ModifySeats=		"Modify seat distribution.";

var xmsgSaveLicenseHdr=			"License(s) Received";
var xmsgSaveLicenseMsg1=		"Your licenses have been received from Autodesk. You must now save them in license files.<p> " +
								"<b>Save License(s) in License Files</b><p>" +
								"<LI>The <b>recommended location</b> for your license file(s) is in a \"License\" directory " +
								"where you installed the Autodesk Network License Manager on your server.&nbsp;&nbsp;";
var xmsgSaveLicenseMsg6=		"<LI>If you have an <b>existing license file</b>, <b>insert</b> the new license into it.<br>" +
								"When you click Next, the system will automatically insert your license information to " +
								"the appropriate location in the existing file.</LI>";
var xmsgSaveLicenseMsg2=		"If the file specified above is an existing license file:";
var xmsgSaveLicenseMsg3=		"Insert the new license information into it.";
var xmsgSaveLicenseMsg4=		"Overwrite the existing license file.";
var xmsgSaveLicenseMsg5=		"Please correct the following errors:";

var xmsgSaveErrorFileNameTooLong=  "ERROR: The filename you entered is too long.<br>" +
								"Change the filename and continue.";
var xmsgSaveErrorNoPermission=	"ERROR: You do not have permission to save the file to the location specified.<br>" +
								"You can save the file to a temporary location, obtain the appropriate permission, and move the file later.";
var xmsgSaveErrorNoDiskSpace=	"ERROR: You do not have enough disk space available to save the file to the location " +
								"specified.<BR>You can save the file to a temporary location, make space available, and move the file later.";
var xmsgSaveErrorInvalidFile=	"ERROR: The new license could not be appended to the file specified without losing " +
								"data. The file specified may have been for different machines or different server models.<BR>" +
								"You can save the new license file with a different name or location and append it to the file manually later.";															
var xmsgSaveErrorPathNotExit=	"ERROR: The specified path does not exist.<BR>Click the Browse button to locate or create the path.";
var xmsgSaveErrorPathBlank=		"ERROR: You must specify a valid path and license file name. Specify the path and " +
								"file name in the field below or browse to locate one.";

var xmsgLicAuthConfirmHdr1=		"License Activation Successful!";
var xmsgLicAuthConfirmHdr2=		"License Server Host Information";
var xmsgLicAuthConfirmMsg1=		"Thank you for registering your product. You can print a record of this information.";
var xmsgLicAuthConfirmDate=		"Date:";

var xmsgLicPathMsg1=			"The following license files have been saved:";
var xmsgLicPathMsg2=			"Your license files have been saved to:";

var xmsgOtherMethodMsg1NSA=		"Use another method to obtain an authorized license.";
var xmsgOtherMethodMsg1=		"Use another method.";

var xmsgContactAutodeskMsg1=	"Use one of the following methods to contact Autodesk.";
var xmsgOfflineActReqMsg=       "Using a computer with an Internet connection, request an activation code for your product license by completing the following request form. Be prepared to provide the Product, Serial Number, Product Key, and Request Code(above)."								
/////////////////////////////////////////////
// Email Options
/////////////////////////////////////////////
var xmsgEmailOptionNSATitle=	"Obtain a License File by Email";
var xmsgEmailOptionTitle=		"Register by Email";
var xmsgEmailOptionNSAMsg=		"Your registration and license server information has been automatically saved " +
								"to a file. The file must be emailed to Autodesk's automated registration processing " +
								"center.<p>When you successfully email the file to Autodesk, you will receive an " +
								"automated response, an authorized license file, and instructions on how to complete " +
								"the process.";
var xmsgEmailOptionMsg=			"Your registration information has been automatically saved to a file. The file must " +
								"be emailed to Autodesk's automated registration processing center.<p>When you successfully email " +
								"the file to Autodesk, you will receive an automated response, and instructions on how " +
								"to complete the process.";
var xmsgEmailOptionMsg2=		"If the default email system you use is currently able to send email over the Internet, " +
								"click Send File Now and then click Next. The file will be sent for you automatically.<p>" +
								"If you do not have access to send email now, click Send File Later. Instructions for " +
								"sending the file manually will be provided.";
var xmsgEmailOptionInfo1=		"Send the file now.";
var xmsgEmailOptionInfo2=		"Send the file later, manually.";
var xmsgEmailOptionInfo3=		"Send a copy of the email to the email address I provided.";

/////////////////////////////////////////////
// Email Error
/////////////////////////////////////////////
var xmsgEmailErrorHdr=			"Unable to create email";
var xmsgEmailErrorMsg1=			"To complete registration by email, attach the following file to an email:";
var xmsgEmailErrorMsg2=			"Send the email to %1.";
var xmsgEmailErrorMsg3=			"You can find the file in the following location:";

/////////////////////////////////////////////
// Local HERE customer information URLs
/////////////////////////////////////////////
var xmsgLocalHERETitle=			"Change Customer Information";
var xmsgLocalHEREInfo=			"To change your customer information, contact your Autodesk Authorized Reseller " +
								"or navigate to a link below that applies to your country or region.";
var xmsgLocalHEREUS=			"Americas";
var xmsgLocalHEREEMEA=			"Europe, Middle East, Africa";
var xmsgLocalHEREAPAC=			"Asia/Pacific";

/////////////////////////////////////////////
// Help
/////////////////////////////////////////////
var xmsgHelpTitle=				"Help";
var xmsgHelpUpgradeMsg=			"If you are registering or activating an upgrade from a previous version, you must "+
								"check this box, and you will be prompted for the serial number from the version "+
								"from which you are upgrading.";
var xmsgHelpUpgradeRequiredTitle=	"Enter the previous product serial number (required for upgrade)";
var xmsgHelpUpgradeRequiredMsg=	"This is the serial number from your previous software version. You can find the "+
								"serial number either in the    Help > About dialog box in the software or on the "+
								"previous product packaging.";

//	Fax or email error message
var xmsgNotEnterErrorMsg=		"You have not entered %1. Please enter this if you wish to receive your activation by this method.";								

//  Help for serial number
var xmsgHelpSerialNumberTitle=  "Serial number"; ////modify by joyce.min on 2007-8-16
var xmsgHelpSerialNumberMsg=    "Your serial number is located on the product package or in your Autodesk Upgrade and Licensing Information email."; // ECO19

//  Help for ProductInfo serial number & Product Key //modify by joyce.min on 2007-8-16
var xmsgHelpProductKeyTitle=   "Product key";
var xmsgHelpProductKeyMsg=    "Your product key is located near the serial number on the product package or in your Autodesk Upgrade and Licensing Information email."; // ECO19

/////////////////////////////////////////////
// The following strings are added back for backward competibility reason
/////////////////////////////////////////////
var xmsgRT0015TempSysErr=				"Connection Error (0.15)";
var xmsgRT010203071213CannotCompErrA=	"Registration Error (1.2.3.7.12.13)";
var xmsgRT09AlreadyReg=					"Already Registered (9)";
var xmsgRT10ExceededAuths=				"Exceeded Auths (10)";
var xmsgRT12StolenSN=					"Stolen Serial Number (12)";
var xmsgRT18OldSNInvalid=				"Previous Serial Number Invalid (18)";
var xmsgRT20DataError=					"Data Error (20)";
var xmsgRT21CustIDTelErr=				"Customer ID/Tel error (21)";
var xmsgRT22NetworkInstallation=		"Network Installation Error (22)";
var xmsgRT900SystemNotResponding=		"System Not Responding (900)";
var xmsgRTCustID=						"Customer ID";
var xmsgRTCustIDConfirm=				"Confirm Identification";
var xmsgRTNewSerialNumber=				"New Serial Number Information";
var xmsgRTNoNewSN=						"Purchase Transaction Error";
var xmsgRTPurchAuthFailed=				"Activation Error";
var xmsgRTPurchConfirmOther=			"Purchase Confirm";
var xmsgRTPurchConfirmPerm=				"Purchase Confirm - Registered and Activated";
var xmsgRTPurchConfirmReg=				"Purchase Confirm - Registered But Not Activated";
var xmsgRTPurchConfirmRegVol=			"Purchase Confirm - Registered";
var xmsgRTPurchConfirmRent=				"Purchase Confirm - Registered and Active Rental";
var xmsgRTPurchConfirmUnReg=			"Purchase Confirm - Not Registered or Activated";
var xmsgRTPurchConnectionFailed=		"Purchase Connection Failed";
var xmsgRTPurchaseError=				"Purchase Error";
var xmsgRTSNMismatch=					"Purchase Transaction Error - Serial Number Mismatch";
var xmsgRTSUNOldSNInvalid=				"Previous Serial Number Invalid - SUN";

var szRTEmail =         "RTEmail.html";

var xmsgExit=			"Exit";

var xmsgCustIDMainTitle=	"Customer Identification";
var xmsgCustIDTitle1=		"Customer ID:";
var xmsgCustIDText2=		"Enter your Customer ID and Telephone Number below. If you do not have a Customer ID, leave both fields blank.<p> ";
var xmsgCustIDText3=		"Note: If you are reactivating your product, you must enter a Customer ID.";
var xmsgCustIDText3NSA=		"Note: If you are reauthorizing your product, you must enter a Customer ID.";
var xmsgCustIDTitle2=		"Telephone number:";
var xmsgCustIDTelEx4=		"(example: 03-111-1234)";
var xmsgRegCustIDTel=		"The Customer ID and Telephone Number that you entered do not match our records. Click one of the following links.";

/////////////////////////////////////////////
//  Note to Localization :
//
//	"xmsgRT113SeatMsg1" appears in NSA_RT113TooManySeats.html.  The full sentence in English is
//
//	"Our records indicate that you have [Max allowed seats] valid [product name] seats available." 
/////////////////////////////////////////////
var xmsgRT113SeatMsg1=	"Our records indicate that you have %1 valid %2 seats available.<br>";

/////////////////////////////////////////////
// Error 12
/////////////////////////////////////////////
var xmsgErr12Hdr=				"The serial number you entered is invalid";
var xmsgErr12APAC=				"<p>This is an invalid serial number and cannot be activated. " +
								"Please contact us at " +
								"<a href=mailto:apacpl@listproc.autodesk.com target=\"_blank\">apacpl@listproc.autodesk.com</a></p>";
var xmsgErr12EMEA=				"<p>Dear Sir/Madam</p>" +
								"<p>Thank you for trying to register your Autodesk&#0174; or Discreet&#0153; software product with Autodesk.</p>" +
								"<p>Unfortunately, our records indicate that the serial number for the Autodesk&#0174; or Discreet&#0153; "+
								"software product you have tried to register with us is not a valid serial number or is the serial "+
								"number of a well known pirate copy of that software product and therefore the Autodesk&#0174; or " +
								"Discreet&#0153; software product you are using is unauthorized.</p>" +
								"<p>Licenses to use Autodesk&#0174; software products can be purchased from Autodesk Authorized " +
								"Resellers - please visit " +
								"<a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a> " +
								"for a list of Autodesk Authorized Resellers or an " +
								"Autodesk office in your area. Use of legal software is the only way in which you can ensure that " +
								"you receive the maximum benefit from using your software AND avoid potential civil and " +
								"possibly criminal prosecution if caught using and/or reproducing software illegally.</p>" +
								"<p>Licenses to use Discreet&#0153; software products can be purchased from Discreet Authorized " +
								"Resellers - please visit " +
								"<a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a> " +
								"for a list of Discreet Authorized Resellers or a " +
								"Discreet office in your area. Use of legal software is the only way in which you can ensure that " +
								"you receive the maximum benefit from using your software AND avoid potential civil and " +
								"possibly criminal prosecution if caught using and/or reproducing software illegally.</p>" +
								"<p>So we kindly request that you  immediately stop using the unauthorized software product you " +
								"have tried to register with us, remove all copies stored on any of your computer hardware, and " +
								"destroy any media containing the software product. While we trust you will voluntarily comply " +
								"with our request, Autodesk reserves its rights in relation to this matter and may pass your details " +
								"to the Business Software Alliance (\"BSA\").</p>" +
								"<p>If you have any questions or believe that you have received this message in error, please contact " +
								"us at: " + //modify the e-mail address by joyce.min on 2007-9-3 as the Raptro recommend
								"<a href=mailto:emea.register@activation.autodesk.com target=\"_blank\">emea.register@activation.autodesk.com</a></p>" +
								"<p>If you would like to provide information regarding the use or sale of illegal software, please " +
								"contact your local Autodesk office or contact the BSA by visiting " +
								"<a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a></p>" +
								"<p>Thank you</p>";
var xmsgErr12US=				"<p>Dear Sir/Madam</p>" +
								"<p>You recently tried to register your software product with Autodesk or Discreet.</p>" +
								"<p>Unfortunately, our records indicate that the serial number for the Autodesk&#0174; or Discreet&#0153; " +
								"software product you have tried to register with us is not a valid serial number or is the serial " +
								"number of a well known pirate copy of that software product and therefore the Autodesk&#0174; or " +
								"Discreet&#0153; software product you are using is unauthorized.</p>" +
								"<p>For Autodesk users, licenses to use Autodesk&#0174; software products can be purchased from " +
								"Autodesk Authorized Resellers - please visit " +
								"<a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a> " +
								"for a list of Autodesk " +
								"Authorized Resellers in your area.  Use of legal software is the only way in which you can " +
								"ensure that you receive the maximum benefit from using your software AND avoid potential " +
								"civil and possibly criminal prosecution if caught using and/or reproducing software illegally.</p>" +
								"<p>For Discreet&#0153; users, licenses to use Discreet&#0153; software products can be purchased from " +
								"Discreet Authorised Resellers - please visit " +
								"<a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a> " +
								"for a list of Discreet Authorized " +
								"Resellers or a Discreet office in your area. Use of legal software is the only way in which you " +
								"can ensure that you receive the maximum benefit from using your software AND avoid potential " +
								"civil and possibly criminal prosecution if caught using and/or reproducing software illegally.</p>" +
								"<p>You must immediately stop using the unauthorized software product you have tried to register " +
								"with us, remove all copies stored on any of your computer hardware, and destroy any media " +
								"containing the software product. While we trust you will voluntarily comply with our request, " +
								"Autodesk reserves its rights in relation to this matter and may pass your details to the Business " +
								"Software Alliance (\"BSA\").</p>" +
								"<p>If you have any questions or believe that you have received this message in error, please contact " +
								"us at: " +
								"<a href=mailto:ProductActivation@activation.autodesk.com target=\"_blank\">ProductActivation@activation.autodesk.com</a></p>" +
								"<p>If you would like to provide information regarding the use or sale of illegal software, please " +
								"contact your local office or contact the BSA by visiting " +
								"<a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a></p>" +
								"<p>Thank you</p>";





// SIG // Begin signature block
// SIG // MIIZNgYJKoZIhvcNAQcCoIIZJzCCGSMCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFD8Y+phoYq8H
// SIG // 46zwU8JLbyEQsSkMoIIUMDCCA+4wggNXoAMCAQICEH6T
// SIG // 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
// SIG // CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
// SIG // cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
// SIG // EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
// SIG // Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
// SIG // aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
// SIG // NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
// SIG // bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
// SIG // bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
// SIG // RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
// SIG // AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
// SIG // FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
// SIG // a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
// SIG // AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
// SIG // +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
// SIG // 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
// SIG // 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
// SIG // RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
// SIG // gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
// SIG // gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
// SIG // aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
// SIG // CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
// SIG // Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
// SIG // bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
// SIG // VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
// SIG // VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
// SIG // BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
// SIG // nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
// SIG // sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
// SIG // JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
// SIG // g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
// SIG // UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
// SIG // dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
// SIG // MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
// SIG // AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
// SIG // cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
// SIG // sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
// SIG // duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
// SIG // TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
// SIG // YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
// SIG // vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
// SIG // nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
// SIG // 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
// SIG // EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
// SIG // FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
// SIG // BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
// SIG // AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
// SIG // MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
// SIG // bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
// SIG // MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
// SIG // VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
// SIG // IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
// SIG // SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
// SIG // st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
// SIG // JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
// SIG // dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
// SIG // bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
// SIG // K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
// SIG // SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
// SIG // ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
// SIG // w7wc2AR1MIIFhTCCBG2gAwIBAgIQKcFbP6rNUmpOZ708
// SIG // Tn4/8jANBgkqhkiG9w0BAQUFADCBtDELMAkGA1UEBhMC
// SIG // VVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYD
// SIG // VQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTswOQYD
// SIG // VQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0cHM6Ly93d3cu
// SIG // dmVyaXNpZ24uY29tL3JwYSAoYykxMDEuMCwGA1UEAxMl
// SIG // VmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNpZ25pbmcgMjAx
// SIG // MCBDQTAeFw0xMjA3MjUwMDAwMDBaFw0xNTA5MjAyMzU5
// SIG // NTlaMIHIMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2Fs
// SIG // aWZvcm5pYTETMBEGA1UEBxMKU2FuIFJhZmFlbDEWMBQG
// SIG // A1UEChQNQXV0b2Rlc2ssIEluYzE+MDwGA1UECxM1RGln
// SIG // aXRhbCBJRCBDbGFzcyAzIC0gTWljcm9zb2Z0IFNvZnR3
// SIG // YXJlIFZhbGlkYXRpb24gdjIxHzAdBgNVBAsUFkRlc2ln
// SIG // biBTb2x1dGlvbnMgR3JvdXAxFjAUBgNVBAMUDUF1dG9k
// SIG // ZXNrLCBJbmMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQCoYmDrmd0Gq8ezSsDlfgaJFEFplNPNhWzM
// SIG // 2uFQaYAB/ggpQ11+N4B6ao+TqrNIWDIqt3JKhaU889nx
// SIG // l/7teWGwuOurstI2Z0bEDhXiXam/bicK2HVLyntliQ+6
// SIG // tT+nlgfN8tgB2NzM0BpE1YCnU2b6DwQw4V7BV+/F//83
// SIG // yGFOpePlumzXxNw9EKWkaq81slmmTxf7UxZgP9PGbLw8
// SIG // gLAPk4PTJI97+5BBqhkLb1YqSfWn3PNMfsNKhw/VwAN0
// SIG // dRKeM6H8SkOdz+osr+NyH86lsKQuics4fwK5uFSHQHsI
// SIG // t6Z0tqWvminRqceUi9ugRlGryh9X1ZqCqfL/ggdzYa3Z
// SIG // AgMBAAGjggF7MIIBdzAJBgNVHRMEAjAAMA4GA1UdDwEB
// SIG // /wQEAwIHgDBABgNVHR8EOTA3MDWgM6Axhi9odHRwOi8v
// SIG // Y3NjMy0yMDEwLWNybC52ZXJpc2lnbi5jb20vQ1NDMy0y
// SIG // MDEwLmNybDBEBgNVHSAEPTA7MDkGC2CGSAGG+EUBBxcD
// SIG // MCowKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlz
// SIG // aWduLmNvbS9ycGEwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // cQYIKwYBBQUHAQEEZTBjMCQGCCsGAQUFBzABhhhodHRw
// SIG // Oi8vb2NzcC52ZXJpc2lnbi5jb20wOwYIKwYBBQUHMAKG
// SIG // L2h0dHA6Ly9jc2MzLTIwMTAtYWlhLnZlcmlzaWduLmNv
// SIG // bS9DU0MzLTIwMTAuY2VyMB8GA1UdIwQYMBaAFM+Zqep7
// SIG // JvRLyY6P1/AFJu/j0qedMBEGCWCGSAGG+EIBAQQEAwIE
// SIG // EDAWBgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG
// SIG // 9w0BAQUFAAOCAQEA2OkGvuiY7TyI6yVTQAYmTO+MpOFG
// SIG // C8MflHSbofJiuLxrS1KXbkzsAPFPPsU1ouftFhsXFtDQ
// SIG // 8rMTq/jwugTpbJUREV0buEkLl8AKRhYQTKBKg1I/puBv
// SIG // bkJocDE0pRwtBz3xSlXXEwyYPcbCOnrM3OZ5bKx1Qiii
// SIG // vixlcGWhO3ws904ssutPFf4mV5PDi3U2Yp1HgbBK/Um/
// SIG // FLr6YAYeZaA8KY1CfQEisF3UKTwm72d7S+fJf++SOGea
// SIG // K0kumehVcbavQJTOVebuZ9V+qU0nk1lMrqve9BnQK69B
// SIG // QqNZu77vCO0wm81cfynAxkOYKZG3idY47qPJOgXKkwmI
// SIG // 2+92ozCCBgowggTyoAMCAQICEFIA5aolVvwahu2WydRL
// SIG // M8cwDQYJKoZIhvcNAQEFBQAwgcoxCzAJBgNVBAYTAlVT
// SIG // MRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UE
// SIG // CxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazE6MDgGA1UE
// SIG // CxMxKGMpIDIwMDYgVmVyaVNpZ24sIEluYy4gLSBGb3Ig
// SIG // YXV0aG9yaXplZCB1c2Ugb25seTFFMEMGA1UEAxM8VmVy
// SIG // aVNpZ24gQ2xhc3MgMyBQdWJsaWMgUHJpbWFyeSBDZXJ0
// SIG // aWZpY2F0aW9uIEF1dGhvcml0eSAtIEc1MB4XDTEwMDIw
// SIG // ODAwMDAwMFoXDTIwMDIwNzIzNTk1OVowgbQxCzAJBgNV
// SIG // BAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEf
// SIG // MB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazE7
// SIG // MDkGA1UECxMyVGVybXMgb2YgdXNlIGF0IGh0dHBzOi8v
// SIG // d3d3LnZlcmlzaWduLmNvbS9ycGEgKGMpMTAxLjAsBgNV
// SIG // BAMTJVZlcmlTaWduIENsYXNzIDMgQ29kZSBTaWduaW5n
// SIG // IDIwMTAgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQD1I0tepdeKuzLp1Ff37+THJn6tGZj+qJ19
// SIG // lPY2axDXdYEwfwRof8srdR7NHQiM32mUpzejnHuA4Jnh
// SIG // 7jdNX847FO6G1ND1JzW8JQs4p4xjnRejCKWrsPvNamKC
// SIG // TNUh2hvZ8eOEO4oqT4VbkAFPyad2EH8nA3y+rn59wd35
// SIG // BbwbSJxp58CkPDxBAD7fluXF5JRx1lUBxwAmSkA8taEm
// SIG // qQynbYCOkCV7z78/HOsvlvrlh3fGtVayejtUMFMb32I0
// SIG // /x7R9FqTKIXlTBdOflv9pJOZf9/N76R17+8V9kfn+Bly
// SIG // 2C40Gqa0p0x+vbtPDD1X8TDWpjaO1oB21xkupc1+NC2J
// SIG // AgMBAAGjggH+MIIB+jASBgNVHRMBAf8ECDAGAQH/AgEA
// SIG // MHAGA1UdIARpMGcwZQYLYIZIAYb4RQEHFwMwVjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L2NwczAqBggrBgEFBQcCAjAeGhxodHRwczovL3d3dy52
// SIG // ZXJpc2lnbi5jb20vcnBhMA4GA1UdDwEB/wQEAwIBBjBt
// SIG // BggrBgEFBQcBDARhMF+hXaBbMFkwVzBVFglpbWFnZS9n
// SIG // aWYwITAfMAcGBSsOAwIaBBSP5dMahqyNjmvDz4Bq1EgY
// SIG // LHsZLjAlFiNodHRwOi8vbG9nby52ZXJpc2lnbi5jb20v
// SIG // dnNsb2dvLmdpZjA0BgNVHR8ELTArMCmgJ6AlhiNodHRw
// SIG // Oi8vY3JsLnZlcmlzaWduLmNvbS9wY2EzLWc1LmNybDA0
// SIG // BggrBgEFBQcBAQQoMCYwJAYIKwYBBQUHMAGGGGh0dHA6
// SIG // Ly9vY3NwLnZlcmlzaWduLmNvbTAdBgNVHSUEFjAUBggr
// SIG // BgEFBQcDAgYIKwYBBQUHAwMwKAYDVR0RBCEwH6QdMBsx
// SIG // GTAXBgNVBAMTEFZlcmlTaWduTVBLSS0yLTgwHQYDVR0O
// SIG // BBYEFM+Zqep7JvRLyY6P1/AFJu/j0qedMB8GA1UdIwQY
// SIG // MBaAFH/TZafC3ey78DAJ80M5+gKvMzEzMA0GCSqGSIb3
// SIG // DQEBBQUAA4IBAQBWIuY0pMRhy0i5Aa1WqGQP2YyRxLvM
// SIG // DOWteqAif99HOEotbNF/cRp87HCpsfBP5A8MU/oVXv50
// SIG // mEkkhYEmHJEUR7BMY4y7oTTUxkXoDYUmcwPQqYxkbdxx
// SIG // kuZFBWAVWVE5/FgUa/7UpO15awgMQXLnNyIGCb4j6T9E
// SIG // mh7pYZ3MsZBc/D3SjaxCPWU21LQ9QCiPmxDPIybMSyDL
// SIG // kB9djEw0yjzY5TfWb6UgvTTrJtmuDefFmvehtCGRM2+G
// SIG // 6Fi7JXx0Dlj+dRtjP84xfJuPG5aexVN2hFucrZH6rO2T
// SIG // ul3IIVPCglNjrxINUIcRGz1UUpaKLJw9khoImgUux5Ol
// SIG // SJHTMYIEcjCCBG4CAQEwgckwgbQxCzAJBgNVBAYTAlVT
// SIG // MRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UE
// SIG // CxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazE7MDkGA1UE
// SIG // CxMyVGVybXMgb2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZl
// SIG // cmlzaWduLmNvbS9ycGEgKGMpMTAxLjAsBgNVBAMTJVZl
// SIG // cmlTaWduIENsYXNzIDMgQ29kZSBTaWduaW5nIDIwMTAg
// SIG // Q0ECECnBWz+qzVJqTme9PE5+P/IwCQYFKw4DAhoFAKBw
// SIG // MBAGCisGAQQBgjcCAQwxAjAAMBkGCSqGSIb3DQEJAzEM
// SIG // BgorBgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgor
// SIG // BgEEAYI3AgEVMCMGCSqGSIb3DQEJBDEWBBTrYa4ryCBF
// SIG // 7nxnsUo8ZwZB7M2q7jANBgkqhkiG9w0BAQEFAASCAQBO
// SIG // qXXd5W05Bwcu6frQrVN+zHidJEy+Yvff3Cv5QryrBwGQ
// SIG // Lw5MKA4SHQk0b+fHHLNEZXzGZqYC4dnav3rrllndJBIm
// SIG // +fLv+Rl929xhSBKIbO0K9pYXt1UZVNCvySDElUXzqCm7
// SIG // aJj8VUaV6Ls7gpAEkXgNMxFKQBq0dnCBXbXZH2O54OnG
// SIG // PJAOdogFn9pzPsu11XamXE7Es08QUt53FHlP16dd0utp
// SIG // eq4sM2a844DrN7hsLgI0NVorb78ttcpmEHrrZDa0+vhH
// SIG // DZ/TuF8CVBbTcWwVfBq2lF8MEUZb6CRpm9HM3LuCIjlx
// SIG // tZfNn+HKFRx9kzA1lAaefgNAyrrBmCQ/oYICCzCCAgcG
// SIG // CSqGSIb3DQEJBjGCAfgwggH0AgEBMHIwXjELMAkGA1UE
// SIG // BhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0
// SIG // aW9uMTAwLgYDVQQDEydTeW1hbnRlYyBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBIC0gRzICEA7P9DjI/r81bgTY
// SIG // apgbGlAwCQYFKw4DAhoFAKBdMBgGCSqGSIb3DQEJAzEL
// SIG // BgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTE0MTIx
// SIG // MjEwMzY1N1owIwYJKoZIhvcNAQkEMRYEFD410IBNRI6A
// SIG // ErkTSrKL2z8qKaQRMA0GCSqGSIb3DQEBAQUABIIBAE31
// SIG // 3ibVgQ9Q7Zm1NyI6gHv8+uWSzlD5gvtQMiYQZ8eRcxuj
// SIG // EUJgiRdWKiS1gO90Z/xW/RJhxcQ5ITk2F94J8yix+fLT
// SIG // Q01YraCiq8pABKQBZLVV4NNvpWMRyZPyqbDxLeUid7ND
// SIG // 9GMDRWS10JW+Ez9YOMjR9ooGEYx3KO6iW09uYbYtwNk4
// SIG // LJb6JrG9m7g7WquKWv23MY1ioZTcTFY1kRc9jbVXo4mE
// SIG // TULWzRad4hnvvpwO4i5NguoYupKTgRi8ISYJcXmePoCn
// SIG // 7Y6iOqRZ7i4DxgaEvvkDWANy0/0Mm4mAZjL+XRdME4eh
// SIG // 5fCQWSFAi0z1xOzXhhEpa6vPn6qvd3c=
// SIG // End signature block
